const int img_width = 100;
const int img_height = 100;
GLubyte the_image[img_height][img_width][3];

void makeimage()
{
   for (int i=0; i<img_width; ++i)
   {
      double x = double(i)/(img_width-1);
      for (int j=0; j<img_height; ++j)
      {
         double y = double(j)/(img_height-1);

         the_image[j][i][0] = int(x*255)*15 % 256;
         the_image[j][i][1] = int(y*255)*15 % 256;
         the_image[j][i][2] = 0.75 * 255;
      }
   }
}

void createtexture(ABITMAP *tex) {	
	glGenTextures(1, &(tex->texID));
	glBindTexture(GL_TEXTURE_2D, tex->texID);
	//glTexImage2D(GL_TEXTURE_2D, 0, 3, tex->width, tex->height, 0, tex->type, GL_UNSIGNED_BYTE, tex->imageData);
	glTexImage2D(GL_TEXTURE_2D, 0, tex->type, tex->width, tex->height, 0, tex->type, GL_UNSIGNED_BYTE, tex->imageData);

	//glTexParameteri(GL_TEXTURE_2D,GL_TEXTURE_MIN_FILTER,GL_NEAREST);
	//glTexParameteri(GL_TEXTURE_2D,GL_TEXTURE_MAG_FILTER,GL_NEAREST);
	glTexParameteri(GL_TEXTURE_2D,GL_TEXTURE_MIN_FILTER,GL_LINEAR);
	glTexParameteri(GL_TEXTURE_2D,GL_TEXTURE_MAG_FILTER,GL_LINEAR);
}

ABITMAP *tmp2;

void createtextures() {
	makeimage();
	/*
	createtexture(planeunoce);
	createtexture(planeocce);
	createtexture(planefiringe);
	createtexture(planeexpe);
	createtexture(planedamagede);
	createtexture(planedamagedoe);
	createtexture(planedamagedfe);
	for(int i = 0; i < numobjects; i++) {
		createtexture(objects[i].obj);
	}
	*/
	//LoadGLTextures();
}

void CalculateFrameRate()
{
	// Below we create a bunch of static variables because we want to keep the information
	// in these variables after the function quits.  We could make these global but that would
	// be somewhat messy and superfluous.  Note, that normally you don't want to display this to
	// the window title bar.  This is because it's slow and doesn't work in full screen.
	// Try using the 3D/2D font's.  You can check out the tutorials at www.gametutorials.com.

	static float framesPerSecond    = 0.0f;							// This will store our fps
    static float lastTime			= 0.0f;							// This will hold the time from the last frame
	static char strFrameRate[50] = {0};								// We will store the string here for the window title

	// Here we get the current tick count and multiply it by 0.001 to convert it from milliseconds to seconds.
	// GetTickCount() returns milliseconds (1000 ms = 1 second) so we want something more intuitive to work with.
    float currentTime = GetTickCount() * 0.001f;				

	// Increase the frame counter
    ++framesPerSecond;

	// Now we want to subtract the current time by the last time that was stored.  If it is greater than 1
	// that means a second has passed and we need to display the new frame rate.  Of course, the first time
	// will always be greater than 1 because lastTime = 0.  The first second will NOT be true, but the remaining
	// ones will.  The 1.0 represents 1 second.  Let's say we got 12031 (12.031) from GetTickCount for the currentTime,
	// and the lastTime had 11230 (11.230).  Well, 12.031 - 11.230 = 0.801, which is NOT a full second.  So we try again
	// the next frame.  Once the currentTime - lastTime comes out to be greater than a second (> 1), we calculate the
	// frames for this last second.
    if( currentTime - lastTime > 1.0f )
    {
		// Here we set the lastTime to the currentTime.  This will be used as the starting point for the next second.
		// This is because GetTickCount() counts up, so we need to create a delta that subtract the current time from.
	    lastTime = currentTime;
		
		// Copy the frames per second into a string to display in the window title bar
		sprintf(strFrameRate, "Current Frames Per Second: %d", int(framesPerSecond));

		// Set the window title bar to our string
		SetWindowText(hWnd, strFrameRate);

		// Reset the frames per second
        framesPerSecond = 0;
    }
}

void gldrawsprite(float x, float y, ABITMAP *bmp) {
	glRasterPos2f(lx + 5, 0.0);
	glBitmap(0,0,0,0,x-lx-5,-y,NULL);
	glDrawPixels(bmp->w, bmp->h, bmp->type, GL_UNSIGNED_BYTE, bmp->imageData);	
}

void gldrawspritehflip(float x, float y, ABITMAP *bmp) {
	glRasterPos2f(lx + 5, 0.0);
	glPixelZoom(-1, 1);
	glBitmap(0,0,0,0,x-lx-5,-y,NULL);
	glDrawPixels(bmp->w, bmp->h, bmp->type, GL_UNSIGNED_BYTE, bmp->imageData);	
	glPixelZoom(1, 1);
}

int newdraw() {
	float cx, mdx, mdy;
	int rowsize, i;
	GLubyte *start;
	poly *p;

	if(level != -1) {								//if not in the menu
		if(center->fixed) {
			if(mouse_x < 100 && center->x > 400) {
				center->x -= (100 - mouse_x) * 0.2;
			}
			else if(mouse_x > 700 && center->x < ground->w - 400) {
				center->x += (mouse_x - 700) * 0.2;
			}
		}

		cx = 0.5 * mouse_x + center->x - 600;
		if(cx < 0) cx = 0;
		if(cx > ground->w - 800) cx = ground->w - 800;
		lx = cx;
		rx = cx + 800;
		mx = mouse_x + cx;
		my = mouse_y;
		mdx = mouse_x + cx;
		mdy = mouse_y;	
		screencenterx = cx + 400;
	}
	else {
		cx = 100;
		lx = 100;
		rx = 900;
		mx = mouse_x + cx;
		my = mouse_y;
		mdx = mouse_x + cx;
		mdy = mouse_y;
		screencenterx = 500;
	}

	CalculateFrameRate();
	//glDisable(GL_BLEND);

	//glClear(GL_COLOR_BUFFER_BIT);
	glClear(GL_COLOR_BUFFER_BIT | GL_DEPTH_BUFFER_BIT);
	glLoadIdentity();
	// Draw image
	//lx = 5;
	glRasterPos2f(0,0.0);
	//glBitmap(0,0,0,0,-lx,-600,NULL);

	glBitmap(0,0,0,0,0,-600,NULL);
	rowsize = bg->w * bg->bypp;
	start = bg->imageData + (int)lx * bg->bypp;

	for(int y = 0; y < 600; y++) {
		glDrawPixels(800, 1, GL_RGB, GL_UNSIGNED_BYTE, start + y * rowsize);
		glBitmap(0,0,0,0,0,1,NULL);
	}
	glTranslatef(-lx,0,0);

	/*
	for(i = 0; i < 16; i++)
		gldrawsprite(100 + 50 * i, 100, explosionanim[i]);
	*/
	

	p = &(polys[0]);
	
	//glPushMatrix();

	glEnable(GL_TEXTURE_2D);

	for(i = 0; i < numpolys; i++, p++) {
		if(p->on && ((p->a->x > lx && p->a->x < rx) || (p->b->x > lx && p->b->x < rx) || (p->c->x > lx && p->c->x < rx))) {
			glBindTexture(GL_TEXTURE_2D, (*(p->tmap))->texID);

			glBegin(GL_TRIANGLES);
				glTexCoord2f(p->v1->u, p->v1->v); glVertex2f(*p->ax, *p->ay);
				glTexCoord2f(p->v2->u, p->v2->v); glVertex2f(*p->bx, *p->by);
				glTexCoord2f(p->v3->u, p->v3->v); glVertex2f(*p->cx, *p->cy);
			glEnd();
		}
	}

	drawbombs();
	drawdebris();
	drawtanks();

	glDisable(GL_TEXTURE_2D);
	

	glColor3f(0.0,0.0,0.0);
	link *l;
	l = &(links[0]);
	for(i = 0; i < numlinks; i++) {
		if(l->on && l->draw && ((l->a->x > lx && l->a->x < rx) || (l->b->x > lx && l->b->x < rx))) {
			glColor3f(l->mycolor.r, l->mycolor.g, l->mycolor.b);
			glBegin(GL_LINES);
				glVertex2f(l->a->x, l->a->y);
				glVertex2f(l->b->x, l->b->y);
			glEnd();
			//line(buf, l->a->x, l->a->y, l->b->x, l->b->y, l->mycolor);
		}
		l++;
	}

	//81

	if(level == -1) {
		gldrawsprite(menux + 250 - 11, menuy + 39, bolt);
		gldrawsprite(menux + 412 - 11, menuy + 39, bolt);
	}

	/*
	if(level == -1 && menuatom->level == 20) {
		glColor3f(1.0,0.0,0.0);
		glBegin(GL_POINTS);
			glVertex2f(menuatom->x, menuatom->y);
		glEnd();
	}
	*/

	if(level == -1 && lmb && !buttonpressed) {
		glColor3f(1.0,0.0,0.0);
		glBegin(GL_POINTS);
			glVertex2f(mx, my);
		glEnd();
	}

	glColor3f(1.0,1.0,1.0);

	/*
	atom *a;
	a = &(atoms[0]);
	glColor3f(0.0,0.0,0.0);
	glPointSize(2);
	for(i = 0; i < numatoms; i++) {
		if(a->on) {
			glColor3f(0.0,1.0,0.0);
			glBegin(GL_POINTS);
				glVertex2f(a->x, a->y);
			glEnd();
		}
		a++;
	}
	*/

	/*
	glColor3f(1.0,1.0,0.0);
	for(i = 0; i < numinteracted; i++) {
		glBegin(GL_LINES);
			glVertex2f(interacted[i][0]->x, interacted[i][0]->y);
			glVertex2f(interacted[i][1]->x, interacted[i][1]->y);
		glEnd();
	}
	*/
	
	drawanimations();
	glColor3f(1.0,1.0,1.0);
	drawsoldiers();

	glColor4f(0.0,0.0,0.0,1.0);
	drawbullets();
	drawhelis();
	glColor3f(1.0,1.0,1.0);
	if(level != -1 && 0) drawguibars();

	if(menumode != -1) drawmenu();

	gldrawsprite(mx - 11, my + 11, mousebmp);

	SwapBuffers(hDC);

	return 1;
}


void olddraw() {
	float cx, mdx, mdy;

	if(center->fixed) {
		if(mouse_x < 100 && center->x > 400) {
			center->x -= (100 - mouse_x) * 0.2;
		}
		else if(mouse_x > 700 && center->x < ground->w - 400) {
			center->x += (mouse_x - 700) * 0.2;
		}
	}

	//cx = (400 + mouse_x) * 0.5 + center->x - 800;//((center->x - 400) + (mouse_x - 400)) * 0.5;
	cx = 0.5 * mouse_x + center->x - 600;
	if(cx < 0) cx = 0;
	if(cx > ground->w - 800) cx = ground->w - 800;
	lx = cx;
	rx = cx + 800;
	mx = mouse_x + cx;
	my = mouse_y - mousebmp->h / 2;
	mdx = mx - mousebmp->w / 2;
	mdy = my - mousebmp->h / 2;
	//position_mouse(nmouse_x - lx, nmouse_y);
	//omouse_x = mouse_x;
	//omouse_y = mouse_y;
	
	//textprintf(buf, font, cx + 10, 10, white, "Health: %f", human->health);
	//textprintf(buf, font, cx + 10, 30, white, "Jeep damage: %f", jeep1.damage);

	drawaaguns();
	drawplanes();
	drawhelis();
	drawatoms();
	drawlinks();
	drawpolys();
	drawtanks();
	drawbullets();
	drawbombs();
	drawdebris();
	drawsoldiers();
	drawanimations();
	drawguibars();

	//if(!human->invehicle)
	draw_sprite(buf, mousebmp, mdx, mdy);

	//save_ABITMAP("sshot.tga", buf);
	//exit(0);
	if(DRAWING) {
	
		vsync();
	
	
		if(!WINDOWED) blit(buf, screen, cx, 0, 0, 0, 800, 600);
		else blit(buf, screen, center->x - 150, center->y - 150, 0, 0, 300, 300);
	}
	//blit(buf, screen, center->x - 50, center->y - 50, 0, 0, 100, 100);
	screencenterx = cx + 400;


	//blit(buf, screen, 1800, 400, 0, 0, 200, 200);

	blit(bg, buf, cx, 10, cx, 10, 200, 10);

	eraseatoms();
	eraselinks();
	erasepolys();
	eraseaaguns();
	eraseplanes();
	erasehelis();
	erasebullets();
	erasetanks();
	erasebombs();
	erasedebris();
	erasesoldiers();
	eraseanimations();
	eraseguibars();
	blit(bg, buf, mdx, mdy, mdx, mdy, mousebmp->w, mousebmp->h);
}